/*  
 * Copyright (C) 2005 Martin Pischky (mailto:martin@pischky.de)  
 *
 * This file (HexFileWriterTest.java) is part of IntelHexFile.
 *
 * IntelHexFile is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
 *
 */

/*
 * $Log: HexFileWriterTest.java,v $
 * Revision 1.1  2005/03/27 12:29:58  pischky
 * added
 *
 */

package org.fremo.ihx.test;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;

import junit.framework.TestCase;

import org.fremo.ihx.ChunkedMemory;
import org.fremo.ihx.HexFileReader;
import org.fremo.ihx.HexFileWriter;
import org.fremo.ihx.InvalidHexFileException;
import org.fremo.ihx.Memory;

/**
 * @author martin
 */
public class HexFileWriterTest extends TestCase {

    public static void main(String[] args) {
        junit.swingui.TestRunner.run(HexFileWriterTest.class);
    }

    /*
     * @see TestCase#setUp()
     */
    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * @see TestCase#tearDown()
     */
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /* (non-Javadoc)
     * @see junit.framework.TestCase#runTest()
     */
    protected void runTest() throws Throwable {
       super.runTest();
    }
    
    public void testWriter1() 
    throws InvalidHexFileException, IOException 
    {
        String in = ":04003F00A42EFE22CB\r\n"
                  + ":00000001FF\r\n";
        HexFileReader hr = new HexFileReader( new StringReader( in ) );
        Memory mem = hr.read();
        hr.close();
        StringWriter out = new StringWriter();
        HexFileWriter hw = new HexFileWriter( out );
        hw.write( mem );
        hw.close();
        assertTrue( "equals in=#"+in+"# out=#"+out+"#", in.equalsIgnoreCase(out.toString()) );
    }

    public void testWriter2() 
    throws InvalidHexFileException, IOException 
    {
        String in = ":10000300E50B250DF509E50A350CF5081200132259\r\n"
                  + ":10001300AC12AD13AE10AF1112002F8E0E8F0F2244\r\n"
                  + ":10002F00EFF88DF0A4FFEDC5F0CEA42EFEEC88F016\r\n"
                  + ":04003F00A42EFE22CB\r\n"
                  + ":0C102300787FE4F6D8FD7581130200030D\r\n"
                  + ":00000001FF\r\n";
        HexFileReader hr = new HexFileReader( new StringReader( in ) );
        Memory mem = hr.read();
        hr.close();
        StringWriter out = new StringWriter();
        HexFileWriter hw = new HexFileWriter( out );
        hw.write( mem );
        hw.close();
        assertTrue( "equals in=#"+in+"# out=#"+out+"#", in.equalsIgnoreCase(out.toString()) );
    }

    public void testWriter3() 
    throws InvalidHexFileException, IOException 
    {
        String exp = ":02000000AA55FF\r\n"
                   + ":01001700FFE9\r\n"
                   + ":01004300FFBD\r\n"
                   + ":01041A00AA37\r\n"
                   + ":01210300FBE0\r\n"
                   + ":01FF03009C61\r\n"
                   + ":01FFFF005AA7\r\n"
                   + ":00000001FF\r\n";
        Memory mem = new ChunkedMemory();
        mem.set( 0, 0xAA );
        mem.set( 1, 0x55 );
        mem.set( 0x0017, (short) -1 );
        mem.set( 0x0043, (short) 255 );
        mem.set( 0x041A, 0xAA );
        mem.set( 0x2103, (byte) -5 );
        mem.set( 0xFF03, (byte) 156 );
        mem.set( 0xFFFF, (byte) 0x5A );
        StringWriter out = new StringWriter();
        HexFileWriter hw = new HexFileWriter( out );
        hw.write( mem );
        hw.close();
        assertTrue( "equals in=#"+exp+"# out=#"+out+"#", exp.equalsIgnoreCase(out.toString()) );
        // parse to check syntax and checksums
        HexFileReader hr = new HexFileReader( new StringReader( out.toString() ) );
        Memory mem2 = hr.read();
        hr.close();
    }
    
    public void testWriter4() 
    throws InvalidHexFileException, IOException 
    {
        int min = Memory.ADDRESS_LOW;
        int max = Memory.ADDRESS_HIGH;
        Memory mem = new ChunkedMemory();
        for (int i = min; i <= max; i++) {
            mem.set( i, i % 64 );
        }
        StringWriter out = new StringWriter();
        HexFileWriter hw = new HexFileWriter( out );
        hw.write( mem );
        hw.close();
        // parse again and check
        HexFileReader hr = new HexFileReader( new StringReader( out.toString() ) );
        Memory mem2 = hr.read();
        hr.close();
        for (int i = min; i <= max; i++) {
            assertEquals( i%64, mem2.get(i) );
        }
    }
    
}
